/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.vlan;

import ibm.nways.jdm.I18NGiblets;
import ibm.nways.jdm.I18NMsgFormat;
import ibm.nways.jdm.I18NString;
import ibm.nways.jdm.JdmServerImpl;
import ibm.nways.jdm.StatusType;
import ibm.nways.jdm.modelgen.StatusMapper;
import ibm.nways.jdm.modelgen.StatusModelInfo;
import ibm.nways.jdm.modelgen.TableStatusNamer;
import java.io.Serializable;

public class ActionVlan
implements StatusMapper,
TableStatusNamer {
    private static String enumBundle = "ibm.nways.vlan.eui.EnumeratedResources";
    private static String vlanBundle = "ibm.nways.vlan.Resources";
    private boolean loggingOn = false;

    public ActionVlan() {
        String string = JdmServerImpl.getProperty("startLogging");
        if (string != null && string.equals("yes")) {
            this.loggingOn = true;
        }
    }

    public void calculateStatus(StatusModelInfo statusModelInfo, StatusModelInfo statusModelInfo2) {
        if (this.loggingOn) {
            System.out.println("ActionVlan");
        }
        Serializable[] serializableArray = statusModelInfo.getIndexes();
        int n = (Integer)serializableArray[0];
        Integer n2 = (Integer)statusModelInfo.get("Panel.IbmVlanAdminStatus");
        Integer n3 = (Integer)statusModelInfo.get("Panel.IbmVlanOperStatus");
        int n4 = n2;
        int n5 = n3;
        if (this.loggingOn) {
            System.out.println("index    = " + serializableArray[0]);
        }
        StatusAndExplain statusAndExplain = this.evaluateAdminOper(n4, n5, n);
        statusModelInfo.setStatusType(statusAndExplain.statType, statusAndExplain.explain, true);
    }

    public I18NString nameThatTableObject(StatusModelInfo statusModelInfo) {
        if (this.loggingOn) {
            System.out.println("ActionVLAN - nameThatTableObject");
        }
        I18NString i18NString = new I18NString(vlanBundle, "STATUS_TABLE_VLAN");
        return i18NString;
    }

    public I18NString nameThatObject(StatusModelInfo statusModelInfo) {
        if (this.loggingOn) {
            System.out.println("ActionVlan - nameThatObject");
        }
        Object[] objectArray = statusModelInfo.getIndexes();
        I18NMsgFormat i18NMsgFormat = new I18NMsgFormat(vlanBundle, "STATUS_NAME", objectArray);
        return i18NMsgFormat;
    }

    private StatusAndExplain evaluateAdminOper(int n, int n2, int n3) {
        StatusAndExplain statusAndExplain = new StatusAndExplain();
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = new Object[]{new Integer(n3)};
        objectArray[0] = new I18NMsgFormat(vlanBundle, "vlanstatus", objectArray2);
        if (n == 1 && n2 == 1) {
            statusAndExplain.statType = StatusType.NORMAL;
            objectArray[1] = new I18NString(enumBundle, "ibm.nways.vlan.model.IbmVlanModel.Panel.IbmVlanOperStatus.enabled");
        } else if (n == 1 && n2 == 2) {
            statusAndExplain.statType = StatusType.CRITICAL;
            objectArray[1] = new I18NString(enumBundle, "ibm.nways.vlan.model.IbmVlanModel.Panel.IbmVlanOperStatus.disabled");
        } else if (n == 2) {
            statusAndExplain.statType = StatusType.ADMIN_DISABLED;
            objectArray[1] = new I18NString(enumBundle, "ibm.nways.vlan.model.IbmVlanModel.Panel.IbmVlanAdminStatus.disabled");
        } else {
            statusAndExplain.statType = StatusType.UNKNOWN;
            objectArray[1] = new I18NString(enumBundle, "unknown");
        }
        statusAndExplain.explain = new I18NGiblets(vlanBundle, "statusorder", objectArray);
        if (this.loggingOn) {
            System.out.println("ret.statType = " + statusAndExplain.statType);
            System.out.println("ret.explain = " + statusAndExplain.explain.getTranslation());
        }
        return statusAndExplain;
    }

    private class StatusAndExplain {
        StatusType statType;
        I18NGiblets explain;

        StatusAndExplain() {
            ActionVlan.this = ActionVlan.this;
        }
    }
}

